<?php

namespace App\Http\Controllers;

use App\Models\Booking;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Routing\Controllers\HasMiddleware;

class DashboardController extends Controller implements HasMiddleware
{
    public static function middleware(): array
    {
        return [
            'auth',
            function (Request $request, Closure $next) {
                if (! user()->can('access-dashboard')) {
                    abort(403);
                }

                return $next($request);
            },
        ];
    }

    public function index()
    {
        if (!user()->address) {
            return redirect()->route('profile.address');
        }
        if (user()->hasRole('admin')) {
            return $this->adminDashboard();
        } elseif (user()->hasRole('agent')) {
            return $this->agent();
        } elseif (user()->hasRole('user')) {
            return $this->user();
        }

        abort(403);
    }

    public function adminDashboard()
    {
        $bookings = Booking::with(['package', 'agent:id,name', 'user:id,name'])->latest()->get();

        return view('admin.dashboard.admin', compact('bookings'));
    }

    public function agent()
    {
        $bookings = Booking::whereAgentId(auth()->id())->with('package')->latest()->get();

        return view('admin.dashboard.agent', compact('bookings'));
    }

    public function user()
    {
        $bookings = Booking::whereUserId(auth()->id())->with('package')->latest()->get();

        return view('admin.dashboard.user', compact('bookings'));
    }
}
